<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Hashtag\Follow;

trait TraitHashtagFollowSetters
{
    use TraitHashtagFollowProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setFollowedHashtagId(string $followedHashtagId)
    {
        $this -> followedHashtagId = $followedHashtagId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setFollowedByUserId(string $followedByUserId)
    {
        $this -> followedByUserId = $followedByUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
